function Figure5C()
% This script plots the data from Figure 5C. Each .mat file contains data
% from three separate biological replicates (mAb_1, mAb_2, mAb_3, etc.)

load 2hr.mat;
A = [mAb_1 mAb_2 mAb_3];
C = [C3_1 C3_2 C3_3];
F = [F_1 F_2 F_3];
[N,x] = hist3([log10(A)',log10(C)'],'Ctrs',{0:.2:7 0:.2:7});
N = N./max(max(N));

XY = [3.1    2.3675
      6.9    4.1712
      6.9    5.9
      3.1    5.9
      3.1    2.3675];
inrec = inpolygon(log10(A),log10(C),XY(:,1),XY(:,2));
R = sum(inrec)/length(C);
St = num2str(R*100); St = [St,'%'];

v0 = [0.05:0.1:1];
figure; 
[M,junk] = contour(x{1},x{2},N',v0); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(A),log10(C),xy(:,1),xy(:,2));
  A(in) = []; C(in) = []; F(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end

figure; plot(log10(A),log10(C),'.','Color',[0.5 0.5 0.5]); title('Aged 2hr'); xlim([0 7]); ylim([0 7]); axis square; hold on;
text(3.2,5.7,St,'FontSize',12,'FontWeight','bold');
contour(x{1},x{2},N',v0,'LineWidth',1.5); colormap('hot'); view(2);  axis equal; xlim([3 7]); ylim([0 6]); 
plot(XY(:,1),XY(:,2),'k--','LineWidth',1.5); 
xlabel('log10[Pre-F mAb intensity per particle]');
ylabel('log10[Post-F mAb intensity per particle]');
drawnow;


load 24hr.mat;
A = [mAb_1 mAb_2 mAb_3];
C = [C3_1 C3_2 C3_3];
F = [F_1 F_2 F_3];
[N,x] = hist3([log10(A)',log10(C)'],'Ctrs',{0:.2:7 0:.2:7});
N = N./max(max(N));

inrec = inpolygon(log10(A),log10(C),XY(:,1),XY(:,2));
R = sum(inrec)/length(C);
St = num2str(R*100); St = [St,'%'];

v0 = [0.05:0.1:1];
figure; 
[M,junk] = contour(x{1},x{2},N',v0); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(A),log10(C),xy(:,1),xy(:,2));
  A(in) = []; C(in) = []; F(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end

figure; plot(log10(A),log10(C),'.','Color',[0.5 0.5 0.5]); title('Aged 24hr'); xlim([0 7]); ylim([0 7]); axis square; hold on;
text(3.2,5.7,St,'FontSize',12,'FontWeight','bold');
contour(x{1},x{2},N',v0,'LineWidth',1.5); colormap('hot'); view(2);  axis equal; xlim([3 7]); ylim([0 6]); 
plot(XY(:,1),XY(:,2),'k--','LineWidth',1.5); 
xlabel('log10[Pre-F mAb intensity per particle]');
ylabel('log10[Post-F mAb intensity per particle]');
drawnow;
  